#ifndef __CHIPH__
#include <list>
#include "aeffectx.h"
using namespace std;

#define CHMAX 16
#define VOMAX 16

//EG State
#define S_AT	 1
#define S_DK	 2
#define S_SUS	3
#define S_RR	 4
#define S_IDLE 0

//OpCode

#define OP_NOTE 0x00
#define OP_VO	 0x20
#define OP_PAN	0x40
#define OP_VOL	0x80
#define OP_FRQ	0xa0

//#define M_CLK 1577960
#define M_CLK 440*1024*1024
#define CMD_MAX 0xfff
#define CMNDBUFSIZE 0xfff

class CHDATA{
	
public:
	unsigned int AR;
	unsigned int DR;
	unsigned int SL;
	unsigned int RR;
	unsigned int BIT;
	unsigned int WT[32];
	unsigned int TAP;
	char Name[16];
	CHDATA(void);
// ~CHDATA(void);

};

struct TBLMIDICH{
	int VoNum; //Fԍ 0-
	int Bend;	//sb`xh -8192`+8191[signed 14bit]
	int Vol;	 //{[ 0-127
	int Pan;	 //L:0x7f,R:0x0
	int BendRang; //sb`xhW@1-??[̔{]
	unsigned int RPN;
	unsigned int NRPN;
	bool CuRPN;
	int BfNote;	//Õm[gԍi|^gpj
	int PortaSpeed;  //|^gXs[h
	bool PortaOnOff;
};

class CHIP{

private:
	unsigned int SampleTime; //HOSTw肳ꂽDelta
	char CuProgName[64];		 //HOSTɑIĂvO
	int CuProgNum;					 //HOSTɑIĂvO
	unsigned int TblPow12[12];
	bool PolyMono;						//Poly true,Mono false
	bool OmniMode;						//Omni on:true off:false
//CHǗoXg
	list<int> PlayCh,WaitCh;
	struct{
		int VoNum;	//Fԍ0-
		int MidiCh; //Midi`l
		int Note;	 //m[gԍ(0-127,gp255)
		int Vel;		//xVeB
		int PortaBend; //|^gp̃xhItZbg
		int PortaSpeed;
	}TblCh[CHMAX];

	struct TBLMIDICH TblMidiCh[16]; //Midi`lݒe[u

	int AtachCh(void);			//`lǉ
	void DelCh(int);				//`l폜
	int ChkEnCh(void);			//󂫃`lԂB
	int ChkSonCh(int,int);	//MidiChƃxVeB蔭̃`lTB
	int NonCh(int,int,int);	//MidiChƃm[gAxVeBŔB
	int NoffCh(int,int);		//MidiChƃm[gŏB

public:
	CHIP(void);							//RXgN^

	class CHDATA VoTbl[VOMAX];		//Fe[u
	MidiProgramName MidiProg[16];	//݂MIDIvOԍ\
	int Init(void);										//
	void setDelta(unsigned int);			//R}hDeltaԐݒ
	void NoteOn(int Ch,int Note,int Vol);	//m[gnm
	void NoteOff(int Ch,int Note);				//m[gnee
	void NoteAllOff(int Ch);							//Sm[gnee
	void ForceAllOff(void);							//~
	void BendCng(int Ch,int Bend);				//sb`xhω
	void VolCng(int Ch,int Vol);					//{[ω
	void VoCng(int Ch,int VoNum);					//F`FW
	void PanCng(int Ch,int Pan);					//Panω
	int getProgNum(void);									//Fio[擾
	void setProgNum(long );								//Fio[Zbg
	void setProgName(char* );							//FZbg
	char* getProgName(void);							//F擾
	char* getProgName(int);								//F擾
	unsigned char getPrm(int);						//index(Vst kNum)ɂp[^Zbg
	void setPrm(int,unsigned char);				//index(Vst kNum)ɂp[^擾
	void setRPNH(int,int);
	void setNRPNH(int,int);
	void setRPNL(int,int);
	void setNRPNL(int,int);
	void setData(int,int);
	void setPoly(bool);
	void setWTY(int ch,int num);
	void setWTX(int ch,int num);
	void pcmset(long,float **,bool);
	void AutoSeq(int sampleframes);
	void setPortaSpeed(int MidiCh,int speed);
	void setPortaOnOff(int MidiCh,bool onoff);
	void setPortaCtr(int MidiCh,int Note);
	void SetSamprate(int sampleRate);
	void setOmni(bool Omni);
~CHIP(void);									//fXgN^
	long getMidiProgram(long channel,MidiProgramName *curProg);

private:
	void CalcPd(int);
	void setReg(unsigned char RegNo,unsigned int data);
	int WaveGen(int ch);

	void ExecuteCmd(unsigned int SamplePoint);
	void Envelope(int ch);

	struct EG{
		int state;
		int Cont;
		int Rest;
	}TblEG[CHMAX];

	int PHA[CHMAX];
	int EGDiv;

	int PDCont[CHMAX];
	int PDReset[CHMAX];
	int RestDelta[CHMAX];
	unsigned char CmdOpBuf[CMD_MAX+1];
	unsigned int CmdDataBuf[CMD_MAX+1];
	unsigned int CmdPos[CMD_MAX+1];
	int CmdIdxW;
	int CmdIdxR;
	int Rate;
	int SampRate;
	int CPan[CHMAX];
	int CVol[CHMAX];
	int pan[CHMAX][2];
	int VoNum[CHMAX];
	int Lpf[CHMAX][32];
	int Sum[CHMAX];
	float LpfX[2][3];
	float LpfY[2][2];
	int CuWT;
};

#define __CHIPH__
#endif
